<?php

require_once "../../../controladores/cobros.controlador.php";
require_once "../../../modelos/cobros.modelo.php";

require_once "../../../controladores/personas.controlador.php";
require_once "../../../modelos/personas.modelo.php";

require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";

require_once "../../../controladores/plantilla.controlador.php";
require_once "../../../modelos/configuracion.modelo.php";

class imprimirComprobante{

public $idcobros;

public function traerImpresionComprobante(){

date_default_timezone_set("America/Mx");
setlocale(LC_ALL, 'spanish');

//TRAEMOS LA INFORMACIÓN DE LA VENTA

$itemContrata = "idcobros";
$valorContrata = $this->idcobros;

$respuestaContrata = ControladorCobros::ctrMostrarCobrosReporte($itemContrata, $valorContrata);

// Verificar que la respuesta sea válida
if(!is_array($respuestaContrata) || empty($respuestaContrata)){
	die("Error: No se encontraron datos para el cobro solicitado.");
}

$urlBase = "https://diplomadosmt.com/sicose_v5/extensiones/tcpdf/pdf/ticket.php?idcobros=";
$urlCompleta = $urlBase . $itemContrata;

$idresponsable = $respuestaContrata[0]['idresponsable'] ?? null;
$usuario = null;
$nombreCobrador = "";
if($idresponsable !== null){
	$usuario = ControladorUsuarios::ctrMostrarUsuarios('id', $idresponsable);
	if(is_array($usuario) && isset($usuario['nombre'])){
		$nombreCobrador = $usuario['nombre'];
	}
}

$plantilla = new ControladorPlantilla();
$configuracionArray = $plantilla -> ctrConfiguracion();
if(!is_array($configuracionArray) || empty($configuracionArray)){
	die("Error: No se pudo cargar la configuración.");
}
$configuracion = $configuracionArray[0];
$logo = $configuracion['logo'];
$razon_social = $configuracion['razon_social'];
$prefijo =  $configuracion['prefijo'];
$celular =  $configuracion['celular'];
$email =  $configuracion['email'];
$direccion =  $configuracion['direccion'];
$tasa_cambio =  $configuracion['cambio'];

$codigo = $respuestaContrata[0]["codigoA"] ?? '';
$codigo2 = $respuestaContrata[0]["codigoR"] ?? '';
$mpago =  $respuestaContrata[0]["mpago"] ?? '';
$notitas =  $respuestaContrata[0]["notitas"] ?? '';
$banco =  $respuestaContrata[0]["banco"] ?? '';
$fecha_cobro_temp = $respuestaContrata[0]["fecha_cobro"] ?? '';
$fecha_cobro = $fecha_cobro_temp ? substr($fecha_cobro_temp, 0, -8) : '';

$fecha_servicio_temp = $respuestaContrata[0]["fecha_servicio"] ?? '';
$fecha = $fecha_servicio_temp ? substr($fecha_servicio_temp, 0, -8) : '';
//$estado = json_decode($respuestaContrata["estado"], true);
$fechaActual = date("Y-m-d H:i:s");
$tipo = $respuestaContrata[0]["tipo"] ?? '';
$estado_valor = $respuestaContrata[0]["estado"] ?? 0;
$estado = "";

if($estado_valor == 0){
	$estado = "Activo";
}else if($estado_valor == 1){
	$estado = "Suspendido";
}else {
	$estado = "Finalizado";
}

$codigoComprobante = "";
$codigoR_temp = $respuestaContrata[0]["codigoR"] ?? 0;

if($codigoR_temp != 0 && $codigoR_temp != ''){
	$codigoComprobante = "SERIE: R - ".$codigoR_temp;
}else{
	$codigoComprobante = "SERIE: A - ".$codigo;
}

$nombreCliente = $respuestaContrata[0]["nombres"] ?? '';
$direccion_cliente = $respuestaContrata[0]["direccion"] ?? '';


//TRAEMOS LA INFORMACIÓN DEL CLIENTE

//$itemCliente = "idpersona";
//$valorCliente = $respuestaContrata["idpersona"];

//$respuestaCliente = ControladorPersonas::ctrMostrarPersonas($itemCliente, $valorCliente);

//TRAEMOS LA INFORMACIÓN DEL VENDEDOR

$itemUsuario = "id";
$valorUsuario = $respuestaContrata[0]["idusuario"];

$respuestaUsuario = ControladorUsuarios::ctrMostrarUsuarios($itemUsuario, $valorUsuario);
$nombreUsuario = "";
if(is_array($respuestaUsuario) && isset($respuestaUsuario['nombre'])){
	$nombreUsuario = $respuestaUsuario['nombre'];
}
$nombreEmpresa = "$razon_social <br>Celular: $prefijo $celular <br> Correo: $email";
//REQUERIMOS LA CLASE TCPDF

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

// ---------------------------------------------------------

$bloque1 = <<<EOF

	<table>

	<tr>

	<td style="width:200px">
	<div>
	<br>
	<img src="../../../$logo" style="width: 140px;">
	</div>
	</td>

	<td style="width:160px">

		<div style="font-size:12px; line-height:15px;">
			<br><br>
		$nombreEmpresa

		</div>

	</td>



	<td style="width:250px; text-align:center; color:red">
		<br><br><br>FOLIO N°.
		<br>$codigo</td>

</tr>

	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ---------------------------------------------------------

$bloque2 = <<<EOF

	<table>

		<tr>

			<td style="width:540px"><img src="images/back.jpg"></td>

		</tr>

	</table>

	<table style="font-size:10px; padding:5px 10px;">

		<tr>

			<td style="border: 1px solid #666; background-color:white; width:390px">

				<b>Alumno:</b> $nombreCliente




			</td>

			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">

				<b>Fecha:</b> $fecha_cobro

			</td>

		</tr>

		<tr>

			<td style="border: 1px solid #666; background-color:white; width:390px"><b>Diplomado:</b> $direccion_cliente </td>


			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">

				<b>Estado:</b> $estado

			</td>

		</tr>
		<tr>

			<td style="border: 1px solid #666; background-color:white; width:390px"><b>cobrado por:</b> $nombreCobrador </td>

			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right"><b>Notas del Cobrador:</b> $notitas </td>




		</tr>
		<tr>
		    <td style="border: 1px solid #666; background-color:white; width:170px; text-align:right"><b>Forma de Pago:</b> $mpago </td>
			<td style="border: 1px solid #666; background-color:white; width:170px; text-align:right"><b>Banco Receptor:</b> $banco </td>
			<td style="border: 1px solid #666; background-color:white; width:200px; text-align:right"><b>Banco Referencia Bancaria:</b> $codigo2 </td>
		</tr>

		<tr>

		<td style="border-bottom: 1px solid #666; background-color:white; width:540px"></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');

// ---------------------------------------------------------

$bloque3 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">

		<tr>

		<td style="border: 1px solid #666; background-color:white; width:175px; text-align:center"><b>Descripción del Servicio</b></td>

		<td style="border: 1px solid #666; background-color:white; width:97px; text-align:center"><b>Tipo Servicio</b></td>

		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>Estado Pago</b></td>



		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>Fecha Pago</b></td>

		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>Valor</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// ---------------------------------------------------------
$total = 0;

foreach ($respuestaContrata as $key => $value) {

	$total = number_format($value["total"] ?? 0, 2, '.', ',');

	$fecha_pago_temp = $value["fechas_pagos"] ?? '';
	$fecha_timestamp = $fecha_pago_temp ? strtotime($fecha_pago_temp) : time();
	$mes  = date("d/m/Y", $fecha_timestamp);

	$estadoPago = "";

	$valor = number_format($value["valor_servicio"] ?? 0, 2, '.', ',');

	$estado_pago_valor = $value["estado_pago"] ?? 0;
	if($estado_pago_valor == 0){
		$estadoPago = "PENDIENTE";
		//$valor = "---------";
	}else if($estado_pago_valor == 1){
		$estadoPago = "PAGADO";
		//$total += $value["valor_servicio"];
	}else if ($estado_pago_valor == 2){
		$estadoPago = "VENCIDO";
		//$valor = "Q.00.00";
	}

$bloque4 = <<<EOF

 	<table style="font-size:10px; padding:5px 10px;">

 		<tr>

			<td style="border: 1px solid #666; color:#333; background-color:white; width:175px; text-align:center">
				{$value['servicio']}
			</td>

			<td style="border: 1px solid #666; color:#333; background-color:white; width:97px; text-align:center">
				{$value['descripcion']}
			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:90px; text-align:center">
 				$estadoPago
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:90px; xt-align:center; text-transform:capitalize;">
 				$mes
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:90px; text-align:center"> $ $total
 			</td>


 		</tr>

 	</table>


EOF;

	$pdf->writeHTML($bloque4, false, false, false, false, '');

}

	$recargo_valor = $respuestaContrata[0]["recargo"] ?? 0;
	if ($recargo_valor == 1){
$bloque5 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">

		<tr>

		<td style="border: 1px solid #666; background-color:white; width:175px; text-align:center"><b>Recargos</b></td>

		<td style="border: 1px solid #666; background-color:white; width:97px; text-align:center"><b></b></td>

		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b></b></td>



		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b></b></td>

		<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>5% Inc</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque5, false, false, false, false, '');

}

$bloque6 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">
		<tr>

			<td style=" background-color:white; width:540px"></td>

		</tr>

		<tr>
			<td style=" background-color:white; width:175px; text-align:center"><b></b></td>
			<td style=" background-color:white; width:97px; text-align:center"><b></b></td>
			<td style=" background-color:white; width:90px; text-align:center"><b></b></td>
			<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>Total</b></td>
			<td style="border: 1px solid #666; background-color:white; width:90px; text-align:center"><b>$ $total</b></td>
		</tr>
		<tr>
			<td style=" background-color:white; width:175px; text-align:center"><b></b></td>
			<td style=" background-color:white; width:97px; text-align:center"><b></b></td>
			<td style=" background-color:white; width:90px; text-align:center"><b></b></td>
			
		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque6, false, false, false, false, '');


$bloque6 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">
		<tr>

		<td style="border:none; background-color:white; width:540px"></td>

		</tr>

		<tr>

		<td style="border:none; background-color:white; width:175px; text-align:center"><b>Elaborado por:</b> $nombreUsuario</td>

		</tr>
		<tr>

		<td style="border:none; background-color:white; width:175px; text-align:center"><b>Fecha de reimpresion:</b> $fechaActual</td>

		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>



		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>

		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque6, false, false, false, false, '');


// Construir la URL completa con el ID variable
$urlBase = "https://diplomadosmt.com/sicose_v5/extensiones/tcpdf/pdf/ticket.php?idcobros=";
$urlCompleta = $urlBase . $valorContrata;

// Configurar el estilo del código QR
$style = array(
    'border' => 0,
    'vpadding' => 'auto',
    'hpadding' => 'auto',
    'fgcolor' => array(0, 0, 0),
    'bgcolor' => array(255, 255, 255),
    'module_width' => 1,
    'module_height' => 1
);

// Generar el código QR
$pdf->write2DBarcode($urlCompleta, 'QRCODE,L', 20, $pdf->getY() + 5, 40, 40, $style, 'N');

// Texto debajo del QR
$pdf->SetXY(10, $pdf->getY() + 3);
$pdf->SetFont('helvetica', '', 8);
$pdf->Cell(40, 5, 'Escanea para verificar la autenticidad ', 0, 0, 'C');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO

$pdf->Output('comprobante.pdf', 'I');

}

}

$factura = new imprimirComprobante();
$factura -> idcobros = $_GET["idcobros"];
$factura -> traerImpresionComprobante();

?>
